<?php
// new post meta data callback
function crown_post_meta_box_callback( $post ) {
	wp_nonce_field( 'crown_meta_box', 'crown_meta_box_nonce' );
	$value = get_post_meta( $post->ID, 'crown_featured_post_value', true );
	echo '<label for="crown_post_intro">';
	esc_html_e( 'This content will be used to replace the featured image, use shortcode here', 'crown' );
	echo '</label><br />';
	wp_editor( $value, 'crown_post_intro', $settings = array() );
}
// register new meta box
add_action( 'add_meta_boxes', 'crown_add_post_meta_box' );
function crown_add_post_meta_box(){
	$screens = array( 'post' );
	foreach ( $screens as $screen ) {
		add_meta_box(
			'crown_post_intro_section',
			esc_html__( 'Post featured content', 'crown' ),
			'crown_post_meta_box_callback',
			$screen
		);
	}
	add_meta_box(
		'crown_page_config_section',
		esc_html__( 'Page config', 'crown' ),
		'crown_page_meta_box_callback',
		'page',
		'normal',
		'high'
	);
}
// new page meta data callback
function crown_page_meta_box_callback( $post ) {
	wp_nonce_field( 'crown_meta_box', 'crown_meta_box_nonce' );
	$header_val = get_post_meta( $post->ID, 'crown_header_page', true );
	$layout_val = get_post_meta( $post->ID, 'crown_layout_page', true );
	$logo_val = get_post_meta( $post->ID, 'crown_logo_page', true );
	$footer_val = get_post_meta( $post->ID, 'crown_footer_page', true );
	$content_layout = get_post_meta( $post->ID, 'crown_content_layout', true );
	echo '<div class="bootstrap">';
		echo '<div class="option row">';
			echo '<div class="option_label col-md-3 col-sm-12"><label for="custom_header_option">' . esc_html__('Custom header:', 'crown') . '</label></div>';
			echo '<div class="option_field col-md-9 col-sm-12"><select id="custom_header_option" name="crown_header_page">';
			echo '<option value="">'. esc_html__('Inherit theme options', 'crown') .'</option>';
			echo '<option value="first"'. (($header_val == 'first') ? ' selected="selected"' : '') .'>'. esc_html__('Header first (Default)', 'crown') .'</option>';
			echo '<option value="second"'. (($header_val == 'second') ? ' selected="selected"' : '') .'>'. esc_html__('Header second', 'crown') .'</option>';
			echo '</select></div>';
		echo '</div>';
		
		echo '<div class="option row">';
			echo '<div class="option_label col-md-3 col-sm-12"><label for="custom_footer_option">' . esc_html__('Custom footer:', 'crown') . '</label></div>';
			echo '<div class="option_field col-md-9 col-sm-12"><select id="custom_footer_option" name="crown_footer_page">';
			echo '<option value="">'. esc_html__('Inherit theme options', 'crown') .'</option>';
			echo '<option value="first"'. (($footer_val == 'first') ? ' selected="selected"' : '') .'>'. esc_html__('Footer first', 'crown') .'</option>';
			echo '</select></div>';
		echo '</div>';
		
		echo '<div class="option row">';
			echo '<div class="option_label col-md-3 col-sm-12"><label for="custom_layout_option">' . esc_html__('Custom layout:', 'crown') . '</label></div>';
			echo '<div class="option_field col-md-9 col-sm-12"><select id="custom_layout_option" name="crown_layout_page">';
			echo '<option value="">'. esc_html__('Inherit theme options', 'crown') .'</option>';
			echo '<option value="full"'. (($layout_val == 'full') ? ' selected="selected"' : '') .'>'. esc_html__('Full (Default)', 'crown') .'</option>';
			echo '<option value="box"'. (($layout_val == 'box') ? ' selected="selected"' : '') .'>'. esc_html__('Box', 'crown') .'</option>';
			echo '</select></div>';
		echo '</div>';
		
		echo '<div class="option row">';
			echo '<div class="option_label col-md-3 col-sm-12"><label for="custom_logo_option">' . esc_html__('Custom logo:', 'crown') . '</label></div>';
			echo '<div class="option_field col-md-9 col-sm-12"><input type="hidden" name="crown_logo_page" id="custom_logo_option" value="'. esc_attr($logo_val) . '" />';
			echo '<div class="wp-media-buttons"><button id="crown_media_button" class="button" type="button"/>'. esc_html__('Upload Logo', 'crown') .'</button><button id="crown_remove_media_button" class="button" type="button">'. esc_html__('Remove', 'crown') .'</button></div>';
			echo '<div id="crown_page_selected_media">'. (($logo_val) ? '<img width="150" src="'. esc_url($logo_val) .'" />':'') .'</div>';
			echo '</div>';
		echo '</div>';
		
		echo '<div class="option row">';
			echo '<div class="option_label col-md-3 col-sm-12"><label for="custom_content_layout">' . esc_html__('Content layout:', 'crown') . '</label></div>';
			echo '<div class="option_field col-md-9 col-sm-12"><select id="custom_content_layout" name="crown_content_layout">';
			echo '<option value="">'. esc_html__('Default layout', 'crown') .'</option>';
			echo '<option value="home2_style"'. (($content_layout == 'home2_style') ? ' selected="selected"' : '') .'>'. esc_html__('Home 2 style', 'crown') .'</option>';
			echo '</select></div>';
		echo '</div>';	
	echo '</div>';
}
// save new meta box value
add_action( 'save_post', 'crown_save_meta_box_data' );
function crown_save_meta_box_data( $post_id ) {
	// Check if our nonce is set.
	if ( ! isset( $_POST['crown_meta_box_nonce'] ) ) {
		return;
	}
	// Verify that the nonce is valid.
	if ( ! wp_verify_nonce( $_POST['crown_meta_box_nonce'], 'crown_meta_box' ) ) {
		return;
	}
	// If this is an autosave, our form has not been submitted, so we don't want to do anything.
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Check the user's permissions.
	if ( isset( $_POST['post_type'] ) && 'page' == $_POST['post_type'] ) {
		if ( ! current_user_can( 'edit_page', $post_id ) ) {
			return;
		}
	} else {
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}
	}
	/* OK, it's safe for us to save the data now. */
	
	// Make sure that it is set.
	if ( isset( $_POST['crown_post_intro'] ) ) {
		// Sanitize user input.
		$my_data = sanitize_text_field( $_POST['crown_post_intro'] );
		// Update the meta field in the database.
		update_post_meta( $post_id, 'crown_featured_post_value', $my_data );
	}
	if ( isset( $_POST['crown_header_page'] ) ) {
		// Sanitize user input.
		$my_data = sanitize_text_field( $_POST['crown_header_page'] );
		// Update the meta field in the database.
		update_post_meta( $post_id, 'crown_header_page', $my_data );
	}
	if ( isset( $_POST['crown_footer_page'] ) ) {
		// Sanitize user input.
		$my_data = sanitize_text_field( $_POST['crown_footer_page'] );
		// Update the meta field in the database.
		update_post_meta( $post_id, 'crown_footer_page', $my_data );
	}
	if ( isset( $_POST['crown_layout_page'] ) ) {
		// Sanitize user input.
		$my_data = sanitize_text_field( $_POST['crown_layout_page'] );
		// Update the meta field in the database.
		update_post_meta( $post_id, 'crown_layout_page', $my_data );
	}
	if ( isset( $_POST['crown_logo_page'] ) ) {
		// Sanitize user input.
		$my_data = sanitize_text_field( $_POST['crown_logo_page'] );
		// Update the meta field in the database.
		update_post_meta( $post_id, 'crown_logo_page', $my_data );
	}
	if ( isset( $_POST['crown_content_layout'] ) ) {
		// Sanitize user input.
		$my_data = sanitize_text_field( $_POST['crown_content_layout'] );
		// Update the meta field in the database.
		update_post_meta( $post_id, 'crown_content_layout', $my_data );
	}
	
	return;
}

function crown_custom_media_upload_field_js($hook) {
	global $post;
	
	wp_enqueue_script('media-upload');
	wp_enqueue_script('thickbox');
	wp_enqueue_style('thickbox');
	
	if ( $hook == 'post-new.php' || $hook == 'post.php' ) {
		if('page' === $post->post_type){
			$media_upload_js = '
				var file_frame;
				jQuery(document).on(\'click\', \'#crown_remove_media_button\', function(e){
					e.preventDefault();
					jQuery(\'#custom_logo_option\').val(\'\');
					jQuery(\'#crown_page_selected_media\').html(\'\');
				});
				jQuery(document).on(\'click\', \'#crown_media_button\', function(e){
					
					if (file_frame){
						file_frame.open();
						return;
					}
					file_frame = wp.media.frames.file_frame = wp.media({
						title: jQuery(this).data(\'uploader_title\'),
						button: {
							text: jQuery(this).data(\'uploader_button_text\'),
						},
						multiple: false
					});
					file_frame.on(\'select\', function(){
						attachment = file_frame.state().get(\'selection\').first().toJSON();
						var url = attachment.url;
						var field = document.getElementById("custom_logo_option");
						field.value = url;
						jQuery(\'#crown_page_selected_media\').html(\'<img width="150" src="\'+ url +\'" />\');
						file_frame.close();
					});
					file_frame.open();
					e.preventDefault();
				});
			';
			wp_add_inline_script( 'media-upload', $media_upload_js );
		}
	}
}
add_action('admin_enqueue_scripts','crown_custom_media_upload_field_js', 10, 1);