<?php

global $product, $crown_opt, $item_layout;
$time_modifiy = get_the_modified_date('Y-m-d');
$new_hot = '';
if(!empty($crown_opt['new_pro_from'])){
	if(strtotime($time_modifiy) >= strtotime($crown_opt['new_pro_from']) && !empty($crown_opt['new_pro_label'])){
		$new_hot = '<span class="newlabel"><span>'. esc_html($crown_opt['new_pro_label']) .'</span></span>';
	}elseif($product->is_featured() && !empty($crown_opt['featured_pro_label'])){
		$new_hot = '<span class="hotlabel"><span>'. esc_html($crown_opt['featured_pro_label']) .'</span></span>';
	}
}elseif($product->is_featured() && !empty($crown_opt['featured_pro_label'])){
	$new_hot = '<span class="hotlabel"><span>'. esc_html($crown_opt['featured_pro_label']) .'</span></span>';
}
?>
	<div class="product-wrapper<?php echo (isset($item_layout) && $item_layout == 'list') ? ' item-list-layout':' item-box-layout'; ?>">
		<div class="list-col4">
			<div class="product-image">
				<?php if ( $product->is_on_sale() ) : ?>
					<?php echo apply_filters( 'woocommerce_sale_flash', '<span class="onsale"><span class="sale-bg"></span><span class="sale-text">' . esc_html__( 'Sale', 'crown' ) . '</span></span>', $post, $product ); ?>
				<?php endif; ?>
				<?php echo $new_hot; ?>
				<a href="<?php echo esc_url( get_permalink( $product->id ) ); ?>" title="<?php echo esc_attr( $product->get_title() ); ?>">
					<?php 
					echo ''.$product->get_image('shop_catalog', array('class'=>'primary_image'));
					
					if(isset($crown_opt['second_image'])){
						if($crown_opt['second_image']){
							$attachment_ids = $product->get_gallery_attachment_ids();
							if ( $attachment_ids ) {
								echo wp_get_attachment_image( $attachment_ids[0], apply_filters( 'single_product_small_thumbnail_size', 'shop_catalog' ), false, array('class'=>'secondary_image') );
							}
						}
					}
					?>
					<span class="shadow"></span>
				</a>
				<?php if((isset($item_layout) && $item_layout == 'box') || (!isset($item_layout))){ ?>
				<div class="actions">
					<ul class="add-to-links clearfix">
						<li>
							<?php echo do_shortcode('[add_to_cart id="'.$product->id.'"]') ?>
						</li>
					</ul>
				</div>
				<?php } ?>
				<div class="products-info">
					<h2 class="product-name">
						<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
					</h2>
					<div class="price-box"><?php echo ''.$product->get_price_html(); ?></div>
				</div>				
			</div>
		</div>
		<div class="list-col8">
			<div class="gridview">
				<h2 class="product-name">
					<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
				</h2>
				<div class="ratings"><?php echo ''.$product->get_rating_html(); ?></div>
				<div class="price-box"><?php echo ''.$product->get_price_html(); ?></div>
				<?php if((isset($item_layout) && $item_layout == 'box') || (!isset($item_layout))){ ?>
				
				<?php } ?>
			</div>
		</div>
	</div>
