<?php
/**
 * The template for displaying product search form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/product-searchform.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see     http://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.4
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$real_id = crown_make_id();
?>

<form role="search" method="get" id="search_mini_form" class="woocommerce-product-search" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
		<div class="search-content">
			<label class="screen-reader-text" for="woocommerce-product-search-field-<?php echo esc_attr($real_id); ?>"><?php esc_html_e( 'Search for:', 'crown' ); ?></label>
			<input type="search" id="woocommerce-product-search-field-<?php echo esc_attr($real_id); ?>" class="search-field" placeholder="<?php echo esc_attr_x( 'Search Products&hellip;', 'placeholder', 'crown' ); ?>" value="<?php echo get_search_query(); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'crown' ); ?>" />
			<input type="submit" class="btn-search" value="<?php echo esc_attr_x( 'Search', 'submit button', 'crown' ); ?>" />
			<input type="hidden" name="post_type" value="product" />
		</div>
</form>