<?php
/**
 * The template for displaying the footer
 *
 * Contains footer content and the closing of the #main and #page div elements.
 *
 * @package WordPress
 * @subpackage Crown_Themes
 * @since Crown Themes 1.0
 */
?>
<?php 
$crown_opt = get_option( 'crown_opt' );
$ft_col_class = '';
?>
	<div class="footer">
		
		<?php if(isset($crown_opt)) { ?>
		<div class="footer-top">
			<div class="container">
				<div class="row">
					
					<?php if(isset($crown_opt['about_us']) && $crown_opt['about_us']!=''){ ?>
						<div class="col-md-4 col-sm-4">
							<div class="widget widget_contact_us">
							
							<?php echo wp_kses($crown_opt['about_us'], array(
									'a' => array(
								'href' => array(),
								'title' => array()
								),
								'div' => array(
									'class' => array(),
								),
								'img' => array(
									'src' => array(),
									'alt' => array()
								),
								'h3' => array(
									'class' => array(),
								),
								'ul' => array(),
								'li' => array(),
								'i' => array(
									'class' => array()
								),
								'br' => array(),
								'em' => array(),
								'strong' => array(),
								'p' => array(),
								)); ?>
								<?php
								if(isset($crown_opt['social_icons'])) {
									echo '<ul class="link-follow">';
									foreach($crown_opt['social_icons'] as $key=>$value ) {
										if($value!=''){
											if($key=='vimeo'){
												echo '<li><a class="'.esc_attr($key).' social-icon" href="'.esc_url($value).'" title="'.ucwords(esc_attr($key)).'" target="_blank"><i class="fa fa-vimeo-square"></i></a></li>';
											} else {
												echo '<li><a class="'.esc_attr($key).' social-icon" href="'.esc_url($value).'" title="'.ucwords(esc_attr($key)).'" target="_blank"><i class="fa fa-'.esc_attr($key).'"></i></a></li>';
											}
										}
									}
									echo '</ul>';
								}
							?>
							</div>
						</div>
					<?php } ?>
					
					<?php
					if( isset($crown_opt['footer_menu1']) && $crown_opt['footer_menu1']!='' ) {
						$menu1_object = wp_get_nav_menu_object( $crown_opt['footer_menu1'] );
						$menu1_args = array(
							'menu_class'      => 'nav_menu',
							'menu'         => $crown_opt['footer_menu1'],
						);
						if (is_object($menu1_object)) {
						?>
						<div class="col-sm-4  col-md-4">
							<div class="widget widget_menu">
								<h3 class="widget-title"><?php echo esc_html($menu1_object->name); ?></h3>
								<?php wp_nav_menu( $menu1_args ); ?>
							</div>
						</div>
						<?php }?>
					<?php }?>
					<?php if(isset($crown_opt['instagram_shortcode']) && $crown_opt['instagram_shortcode']!=''){ ?>
						<div class="col-sm-4">
							<div class="widget widget_instagramfeed">
								<?php if(isset($crown_opt['instagram_title']) && $crown_opt['instagram_title']!=''){ ?>
									<h3 class="widget-title"><?php echo esc_html($crown_opt['instagram_title']);?></h3>
								<?php } ?>
								<?php echo do_shortcode($crown_opt['instagram_shortcode']);?>
							</div>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
		<?php } ?>
		<div class="footer-bottom">
			<div class="container">
				<div class="row">
					<?php if(!empty($crown_opt['newsletter_form'])){ ?>
						<div class="col-sm-6">
							<?php if(!empty($crown_opt['newletter_title'])){ ?>
								<h3 class="newletter-title"><?php echo esc_html($crown_opt['newletter_title']); ?></h3>
							<?php } ?>
							
								<div class="newletter-form-wrapper">
								<?php echo do_shortcode('[wysija_form id="'. intval($crown_opt['newsletter_form']) .'"]'); ?>
								</div>
							
						</div>
					<?php } ?>
					<div class="col-sm-6">

						<div class="widget-copyright">
							<?php 
							if( isset($crown_opt['copyright']) && $crown_opt['copyright']!='' ) {
								echo wp_kses($crown_opt['copyright'], array(
									'a' => array(
										'href' => array(),
										'title' => array()
									),
									'br' => array(),
									'em' => array(),
									'strong' => array(),
								));
							} else {
								echo 'Copyright <a href="'.esc_url( home_url( '/' ) ).'">'.get_bloginfo('name').'</a> '.date('Y').'. All Rights Reserved';
							}
							?>
						</div>
					</div>
						
				</div>
			</div>
		</div>
		
	</div>
	