<?php
/**
 * The Header template for our theme
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Crown_Themes
 * @since Crown Themes 1.0
 */
 
$crown_opt = get_option( 'crown_opt' );
$logo = ( !empty($crown_opt['logo_main']['url']) ) ? $crown_opt['logo_main']['url'] : '';
if(get_post_meta( get_the_ID(), 'crown_logo_page', true )){
	$logo = get_post_meta( get_the_ID(), 'crown_logo_page', true );
}
?>
	<div class="header-container first">
		<div class="top-bar">
			<div class="container">
				<div class="row">
					<div class="col-sm-6 nav-top-bar">
						<?php if(isset($crown_opt['hotline']) && $crown_opt['hotline']!=''){ ?>
							<p class="hotline pull-left">
								<?php echo wp_kses($crown_opt['hotline'], array(
								  'strong' => array(),
								 )); ?>
						
							</p>
						<?php } ?> 
						<?php if(isset($crown_opt['work_time']) && $crown_opt['work_time']!=''){ ?>
							<p class="work-time pull-left">
								<?php echo wp_kses($crown_opt['work_time'], array(
								  'strong' => array(),
								 )); ?>
						
							</p>
						<?php } ?> 
					</div>
					<div class="col-sm-6 social-bar">
						<div class="login-page pull-right">
							<a class="acc-btn" href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" title="<?php esc_html_e('Login or Register','crown'); ?>"><?php esc_html_e('Login','crown'); ?></a>
						</div>
						<?php if (is_active_sidebar('top_header_1')) { ?> 
							<div class="widgets-top">
								<div class="top-lang">
									<i class="fa fa-language"></i><?php echo esc_html__('English', 'crown')?></div>
								<div class="top-header-content">
									<?php dynamic_sidebar('top_header_1'); ?> 
								</div>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
		
		<div class="header">
			<div class="container">
				<div class="row">
					<div class="col-md-3 col-sm-6 col-xs-6 col-logo">
						<?php if( $logo ){ ?>
							<div class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php echo esc_url($logo); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"/></a></div>
						<?php
						} else { ?>
							<h1 class="logo text-center"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php
						} ?>
					</div>
					<div class="col-md-9 col-sm-6 col-xs-6 col-menu">
						<div class="nav-menus pull-left">
							<div class="nav-desktop visible-lg visible-md">
								<?php wp_nav_menu( array( 'theme_location' => 'primary', 'container_class' => 'primary-menu-container', 'menu_class' => 'nav-menu' ) ); ?>
							</div>
							
							<div class="nav-mobile visible-xs visible-sm">
								<div class="mobile-menu-overlay"></div>
								<div class="toggle-menu"><i class="fa fa-bars"></i></div>
								<div class="mobile-navigation">
									<?php wp_nav_menu( array( 'theme_location' => 'mobilemenu', 'container_class' => 'mobile-menu-container', 'menu_class' => 'nav-menu mobile-menu' ) ); ?>
								</div>
							</div>
						</div>
						<?php if(class_exists('WC_Widget_Cart')) { ?>
							<div class="shoping_cart pull-right">
							<?php the_widget('WC_Widget_Cart'); ?>
							</div>
						<?php } ?>
						<?php if(class_exists('WC_Widget_Product_Search')) { ?>
						<div class="top-search pull-right">
							<div class="dropdown">
								<div class="dropdown-toggle">
									<div class="top-search">
										<i class="fa fa-search"></i>
									</div>
								</div>
							<?php the_widget('WC_Widget_Product_Search', array('title' => '')); ?>
							</div>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
		<div class="clearfix"></div>
	</div>