<?php
/**
 * The Header template for our theme
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package WordPress
 * @subpackage Crown_Themes
 * @since Crown Themes 1.0
 */
 
$crown_opt = get_option( 'crown_opt' );
$logo = ( !empty($crown_opt['logo_main']['url']) ) ? $crown_opt['logo_main']['url'] : '';
if(get_post_meta( get_the_ID(), 'crown_logo_page', true )){
	$logo = get_post_meta( get_the_ID(), 'crown_logo_page', true );
}
?>
	<div class="header-container layout2">
		<div class="header">
			<div class="container-fluid">
				<div class="row">
					<div class="col-lg-5 col-sm-5 col-xs-2">
						<div class="nav-menus pull-left">
							<div class="nav-desktop visible-lg visible-md">
								<?php wp_nav_menu( array( 'theme_location' => 'primary', 'container_class' => 'primary-menu-container', 'menu_class' => 'nav-menu' ) ); ?>
							</div>
							
							<div class="nav-mobile visible-xs visible-sm">
								<div class="mobile-menu-overlay"></div>
								<div class="toggle-menu"><i class="fa fa-bars"></i></div>
								<div class="mobile-navigation">
									<?php wp_nav_menu( array( 'theme_location' => 'mobilemenu', 'container_class' => 'mobile-menu-container', 'menu_class' => 'nav-menu mobile-menu' ) ); ?>
								</div>
							</div>
						</div>
					</div>
					<div class="col-md-2 col-sm-2 col-xs-6 col-logo">
						<?php if( $logo ){ ?>
							<div class="logo"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><img src="<?php echo esc_url($logo); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>"/></a></div>
						<?php
						} else { ?>
							<h1 class="logo text-center"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php
						} ?>
					</div>
					<div class="col-lg-5 col-sm-5 col-xs-4 col-menu">
						<?php if(is_active_sidebar('top_header_2')){ ?>
						<div class="header-top-setting pull-right">
							<i class="fa fa-bars"> </i>
							<div class="setting-container">
							<?php if (is_active_sidebar('top_header_2')) { ?> 
								<?php dynamic_sidebar('top_header_2'); ?> 
							<?php } ?>
							</div>
						</div>
						<?php } ?>
						
						<?php if(class_exists('WC_Widget_Cart')) { ?>
							<div class="shoping_cart pull-right">
							<?php the_widget('WC_Widget_Cart'); ?>
							</div>
						<?php } ?>
						<?php if(class_exists('WC_Widget_Product_Search')) { ?>
						<div class="top-search pull-right">
							<div class="dropdown">
								<div class="dropdown-toggle">
									<div class="top-search">
										<i class="fa fa-search"></i>
									</div>
								</div>
								<?php the_widget('WC_Widget_Product_Search', array('title' => '')); ?>
							</div>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
		<div class="clearfix"></div>
	</div>