<?php
/**
 * The Header template for our theme
 *
 * @package WordPress
 * @subpackage Crown_theme
 * @since Crown Themes 1.0
 */
?>
<?php 

$crown_opt = get_option( 'crown_opt' );

?>


<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11" />
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<?php wp_head(); ?>
</head>
<?php
	$crown_layout = (isset($crown_opt['page_layout']) && $crown_opt['page_layout'] == 'box') ? 'box-layout':'';
	$crown_header = (empty($crown_opt['header_layout']) || $crown_opt['header_layout'] == 'default') ? 'first': $crown_opt['header_layout'];
	$crown_content_layout = '';
	if(get_post_meta( get_the_ID(), 'crown_header_page', true )){
		$crown_header = get_post_meta( get_the_ID(), 'crown_header_page', true );
	}
	if(get_the_ID()){
		$crown_layout = get_post_meta( get_the_ID(), 'crown_layout_page', true );
		$crown_content_layout = get_post_meta( get_the_ID(), 'crown_content_layout', true );
	}
?>
<body <?php body_class(); ?>>
<div class="main-wrapper <?php echo esc_attr($crown_layout); ?>">
<?php do_action('before'); ?> 
	<header>
	<?php
		get_header($crown_header);
	?>
	</header>
	<div id="content" class="site-content <?php echo esc_attr($crown_content_layout); ?>">