<?php
add_action( 'vc_before_init', 'crown_vc_shortcodes' );

function crown_get_allCategory(){
	$args = array(
		'type' => 'post',
		'child_of' => 0,
		'parent' => '',
		'orderby' => 'id',
		'order' => 'ASC',
		'hide_empty' => false,
		'hierarchical' => 1,
		'exclude' => '',
		'include' => '',
		'number' => '',
		'taxonomy' => 'product_cat', 
		'pad_counts' => false,
	);
	$categories = get_categories( $args );
	$product_categories_dropdown = array();
	crown_getCategoryChildsFull( 0, 0, $categories, 0, $product_categories_dropdown );
	return $product_categories_dropdown;
}
function crown_getCategoryChildsFull( $parent_id, $pos, $array, $level, &$dropdown ) {
	for ( $i = $pos; $i < count( $array ); $i ++ ) {
		if ( isset($array[ $i ]->category_parent) && $array[ $i ]->category_parent == $parent_id ) {
			$name = str_repeat( "- ", $level ) . $array[ $i ]->name;
			$value = $array[ $i ]->slug;
			$dropdown[] = array( 'label' => $name, 'value' => $value );
			crown_getCategoryChildsFull( $array[ $i ]->term_id, $i, $array, $level + 1, $dropdown );
		}
	}
}
function crown_vc_shortcodes() {
	vc_add_param( 'vc_row', array(
		 'type' => 'checkbox',
		 'heading' => esc_html__('Full Width', 'crown'),
		 'param_name' => 'fullwidth',
		 'value' => array(
						'Yes, please' => true
					)
	));
	
	//Brand logos
	vc_map( array(
		'name' => esc_html__( 'Brand Logos', 'crown' ),
		'base' => 'ourbrands',
		'class' => '',
		'category' => esc_html__( 'Crown Theme', 'crown'),
		'params' => array(
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Title', 'crown' ),
				'param_name' => 'title',
				'value' => '',
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Brand list', 'crown' ),
				'param_name' => 'brand_logos',
				'value' => array(
						esc_html__('List 1', 'crown')	=> 'brand_logos_1',
						esc_html__('List 2', 'crown')	=> 'brand_logos_2',
					),
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Widget style', 'crown' ),
				'param_name' => 'widget_style',
				'value' => array(
						esc_html__('Default', 'crown')	=> '',
						esc_html__('Line style', 'crown')	=> 'line-style',
					),
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Number of columns', 'crown' ),
				'param_name' => 'colsnumber',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
						'6'	=> '6',
					),
				'save_always' => true,
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Number of rows', 'crown' ),
				'param_name' => 'rows',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Style', 'crown' ),
				'param_name' => 'style',
				'value' => array(
						esc_html__( 'Grid', 'crown' )	 	=> 'grid',
						esc_html__( 'List', 'crown' )	 	=> 'list',
						esc_html__( 'Carousel', 'crown' ) 	=> 'carousel',
					),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Extra class name', 'crown' ),
				'param_name' => 'el_class',
				'value' => '',
				'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count desktop small', 'crown' ),
				'param_name' => 'desksmall',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count tablet', 'crown' ),
				'param_name' => 'tablet_count',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count tablet small', 'crown' ),
				'param_name' => 'tabletsmall',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count mobile', 'crown' ),
				'param_name' => 'mobile_count',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Margin', 'crown' ),
				'param_name' => 'margin',
				'value' => '30',
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
		)
	) );
	
	
	//Feature content widget
	vc_map( array(
		'name' => esc_html__( 'Feature content', 'crown' ),
		'base' => 'featuredcontent',
		'class' => '',
		'category' => esc_html__( 'Crown Theme', 'crown'),
		'params' => array(
			array(
				'type' => 'iconpicker',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Icon', 'crown' ),
				'param_name' => 'icon',
				'value' => '',
			),
			array(
				'type' => 'textarea_raw_html',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Feature text', 'crown' ),
				'param_name' => 'feature_text',
				'value' => '',
			),
			array(
				'type' => 'textarea_raw_html',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Short description', 'crown' ),
				'param_name' => 'short_desc',
				'value' => '',
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Layout style', 'crown' ),
				'param_name' => 'style',
				'value' => array(
						esc_html__('Style 1', 'crown')	=> '',
						esc_html__('Style 2', 'crown')	=> 'style_2',
						esc_html__('Style 3', 'crown')	=> 'style_3',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option for list style defined help for theme design.', 'crown' )
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Extra class name', 'crown' ),
				'param_name' => 'el_class',
				'value' => '',
				'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'crown' )
			)
		)
	) );
	
	//Specify Products
	vc_map( array(
		'name' => esc_html__( 'Specify Products', 'crown' ),
		'base' => 'specifyproducts',
		'class' => '',
		'category' => esc_html__( 'Crown Theme', 'crown'),
		'params' => array(
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Title', 'crown' ),
				'param_name' => 'title',
				'value' => '',
			),
			array(
				'type' => 'textarea',
				'heading' => esc_html__('Short Description', 'crown'),
				'param_name' => 'short_desc',
				'holder' => 'div',
				'class' => '',
				'value' => '',
				'save_always' => true,
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Widget style', 'crown' ),
				'param_name' => 'widget_style',
				'value' => array(
						esc_html__('Default', 'crown')	=> '',
						esc_html__('Line style', 'crown')	=> 'line-style',
					),
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Type', 'crown' ),
				'param_name' => 'type',
				'value' => array(
						esc_html__( 'Best Selling', 'crown' )		=> 'best_selling',
						esc_html__( 'Featured Products', 'crown' ) => 'featured_product',
						esc_html__( 'Top Rate', 'crown' ) 			=> 'top_rate',
						esc_html__( 'Recent Products', 'crown' ) 	=> 'recent_product',
						esc_html__( 'On Sale', 'crown' ) 			=> 'on_sale',
						esc_html__( 'Recent Review', 'crown' ) 	=> 'recent_review',
						esc_html__( 'Product Deals', 'crown' )		 => 'deals'
					),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Number of products to show', 'crown' ),
				'param_name' => 'number',
				'value' => '10',
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Style', 'crown' ),
				'param_name' => 'style',
				'value' => array(
						esc_html__( 'Grid', 'crown' )	 	=> 'grid',
						esc_html__( 'List', 'crown' ) 		=> 'list',
						esc_html__( 'Carousel', 'crown' ) 	=> 'carousel',
					),
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Item layout', 'crown' ),
				'param_name' => 'item_layout',
				'value' => array(
						esc_html__( 'Box', 'crown' ) 		=> 'box',
						esc_html__( 'List', 'crown' ) 	=> 'list',
					),
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Number of rows', 'crown' ),
				'param_name' => 'rows',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns', 'crown' ),
				'param_name' => 'columns',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Extra class name', 'crown' ),
				'param_name' => 'el_class',
				'value' => '',
				'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count desktop small', 'crown' ),
				'param_name' => 'desksmall',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count tablet', 'crown' ),
				'param_name' => 'tablet_count',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count tablet small', 'crown' ),
				'param_name' => 'tabletsmall',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count mobile', 'crown' ),
				'param_name' => 'mobile_count',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4', 
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Margin', 'crown' ),
				'param_name' => 'margin',
				'value' => '30',
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
		)
	) );
	//Products Category
	vc_map( array(
		'name' => esc_html__( 'Products Category', 'crown' ),
		'base' => 'productscategory',
		'class' => '',
		'category' => esc_html__( 'Crown Theme', 'crown'),
		'params' => array(
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Title', 'crown' ),
				'param_name' => 'title',
				'value' => '',
			),
			array(
				'type' => 'textarea',
				'heading' => esc_html__('Short Description', 'crown'),
				'param_name' => 'short_desc',
				'holder' => 'div',
				'class' => '',
				'value' => '',
				'save_always' => true,
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Widget style', 'crown' ),
				'param_name' => 'widget_style',
				'value' => array(
						esc_html__('Default', 'crown')	=> '',
						esc_html__('Line style', 'crown')	=> 'line-style',
					),
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Category', 'crown' ),
				'param_name' => 'category',
				'value' => crown_get_allCategory(),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Number of products to show', 'crown' ),
				'param_name' => 'number',
				'value' => '10',
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Style', 'crown' ),
				'param_name' => 'style',
				'value' => array(
						esc_html__( 'Grid', 'crown' )	 	=> 'grid',
						esc_html__( 'List', 'crown' ) 		=> 'list',
						esc_html__( 'Carousel', 'crown' ) 	=> 'carousel',
					),
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Item layout', 'crown' ),
				'param_name' => 'item_layout',
				'value' => array(
						esc_html__( 'Box', 'crown' ) 		=> 'box',
						esc_html__( 'List', 'crown' ) 	=> 'list',
					),
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Number of rows', 'crown' ),
				'param_name' => 'rows',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns', 'crown' ),
				'param_name' => 'columns',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Extra class name', 'crown' ),
				'param_name' => 'el_class',
				'value' => '',
				'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count desktop small', 'crown' ),
				'param_name' => 'desksmall',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count tablet', 'crown' ),
				'param_name' => 'tablet_count',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count tablet small', 'crown' ),
				'param_name' => 'tabletsmall',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count mobile', 'crown' ),
				'param_name' => 'mobile_count',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Margin', 'crown' ),
				'param_name' => 'margin',
				'value' => '30',
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
		)
	) );
	
	//Testimonials
	vc_map( array(
		'name' => esc_html__( 'Crown Testimonials', 'crown' ),
		'base' => 'testimonials',
		'class' => '',
		'category' => esc_html__( 'Crown Theme', 'crown'),
		'params' => array(
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Title', 'crown' ),
				'param_name' => 'title',
				'value' => '',
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Widget style', 'crown' ),
				'param_name' => 'widget_style',
				'value' => array(
						esc_html__('Default', 'crown')	=> '',
						esc_html__('Line style', 'crown')	=> 'line-style',
					),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Number of products to show', 'crown' ),
				'param_name' => 'number',
				'value' => '10',
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Style', 'crown' ),
				'param_name' => 'style',
				'value' => array(
						esc_html__( 'Carousel', 'crown' ) 	=> 'carousel',
						esc_html__( 'List', 'crown' ) 		=> 'list',
					),
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns', 'crown' ),
				'param_name' => 'columns',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Extra class name', 'crown' ),
				'param_name' => 'el_class',
				'value' => '',
				'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count desktop small', 'crown' ),
				'param_name' => 'desksmall',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count tablet', 'crown' ),
				'param_name' => 'tablet_count',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count tablet small', 'crown' ),
				'param_name' => 'tabletsmall',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count mobile', 'crown' ),
				'param_name' => 'mobile_count',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Margin', 'crown' ),
				'param_name' => 'margin',
				'value' => '30',
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
		)
	) );
	
	//MailPoet Newsletter Form
	vc_map( array(
		'name' => esc_html__( 'Newsletter Form (MailPoet)', 'crown' ),
		'base' => 'wysija_form',
		'class' => '',
		'category' => esc_html__( 'Crown Theme', 'crown'),
		'params' => array(
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Form ID', 'crown' ),
				'param_name' => 'id',
				'value' => esc_html__( '', 'crown' ),
				'description' => esc_html__( 'Enter form ID here', 'crown' ),
			)
		)
	) );
	
	//Latest posts
	vc_map( array(
		'name' => esc_html__( 'Blog posts', 'crown' ),
		'base' => 'blogposts',
		'class' => '',
		'category' => esc_html__( 'Crown Theme', 'crown'),
		'params' => array(
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Title', 'crown' ),
				'param_name' => 'title',
				'value' => '',
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Widget style', 'crown' ),
				'param_name' => 'widget_style',
				'value' => array(
						esc_html__('Default', 'crown')	=> '',
						esc_html__('Line style', 'crown')	=> 'line-style',
					),
			),
			array(
				'type' => 'textarea',
				'heading' => esc_html__('Short Description', 'crown'),
				'param_name' => 'short_desc',
				'holder' => 'div',
				'class' => '',
				'value' => '',
				'save_always' => true,
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Number of post to show', 'crown' ),
				'param_name' => 'number',
				'value' => '5',
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Style', 'crown' ),
				'param_name' => 'style',
				'value' => array(
						esc_html__( 'Carousel', 'crown' ) 	=> 'carousel',
						esc_html__( 'List', 'crown' ) 		=> 'list',
						esc_html__( 'Grid', 'crown' )	 	=> 'grid',
					),
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Number of rows', 'crown' ),
				'param_name' => 'rows',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns', 'crown' ),
				'param_name' => 'columns',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Image scale', 'crown' ),
				'param_name' => 'image',
				'value' => array(
						esc_html__( 'Wide', 'crown' )	=> 'wide',
						esc_html__( 'Square', 'crown' ) => 'square',
					),
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Excerpt length', 'crown' ),
				'param_name' => 'length',
				'value' => '20',
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Order by', 'crown' ),
				'param_name' => 'orderby',
				'value' => array(
						esc_html__( 'Posted Date', 'crown' )	=> 'date',
						esc_html__( 'Ordering', 'crown' ) => 'menu_order',
						esc_html__( 'Random', 'crown' ) => 'rand',
					),
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Order Direction', 'crown' ),
				'param_name' => 'order',
				'value' => array(
						esc_html__( 'Descending', 'crown' )	=> 'DESC',
						esc_html__( 'Ascending', 'crown' ) => 'ASC',
					),
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count desktop small', 'crown' ),
				'param_name' => 'desksmall',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count tablet', 'crown' ),
				'param_name' => 'tablet_count',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count tablet small', 'crown' ),
				'param_name' => 'tabletsmall',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'dropdown',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Columns count mobile', 'crown' ),
				'param_name' => 'mobile_count',
				'value' => array(
						'1'	=> '1',
						'2'	=> '2',
						'3'	=> '3',
						'4'	=> '4',
						'5'	=> '5',
					),
				'save_always' => true,
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Margin', 'crown' ),
				'param_name' => 'margin',
				'value' => '30',
				'description' => esc_html__( 'This option only apply for Carousel Stype.', 'crown' )
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Extra class name', 'crown' ),
				'param_name' => 'el_class',
				'value' => '',
				'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'crown' )
			),
		)
	) );
	
	//Custom countdown
	vc_map( array(
		'name' => esc_html__( 'Crown Countdown timer', 'crown' ),
		'base' => 'crown_countdown',
		'class' => '',
		'category' => esc_html__( 'Crown Theme', 'crown'),
		'params' => array(
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Title', 'crown' ),
				'param_name' => 'title',
				'value' => '',
			),
			array(
				'type' => 'textarea',
				'heading' => esc_html__('Short Description', 'crown'),
				'param_name' => 'short_desc',
				'holder' => 'div',
				'class' => '',
				'value' => '',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Date time expires', 'crown'),
				'param_name' => 'datetime',
				'holder' => 'div',
				'class' => '',
				'value' => '',
				'description' => esc_html__( 'Format must be yyyy-mm-dd HH:mm:ss', 'crown' )
			),
			array(
				'type' => 'textfield',
				'holder' => 'div',
				'class' => '',
				'heading' => esc_html__( 'Extra class name', 'crown' ),
				'param_name' => 'el_class',
				'value' => '',
				'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'crown' )
			),
		)
	) );
}
// Filter to replace default css class names for vc_row shortcode and vc_column
add_filter( 'vc_shortcodes_css_class', 'crown_custom_css_classes_for_vc_row_and_vc_column', 10, 2 );
function crown_custom_css_classes_for_vc_row_and_vc_column( $class_string, $tag ) {
  $class_string = preg_replace( '/vc_col-sm-(\d{1,2})/', 'col-sm-$1', $class_string ); // This will replace "vc_col-sm-%" with "my_col-sm-%"
  $class_string = str_replace('vc_column_container', 'column_container', $class_string);
  return $class_string; // Important: you should always return modified or original $class_string
}
?>