<?php

/**
  ReduxFramework Sample Config File
  For full documentation, please visit: https://docs.reduxframework.com
 * */

if (!class_exists('Crown_Theme_Config')) {

    class Crown_Theme_Config {

        public $args        = array();
        public $sections    = array();
        public $theme;
        public $ReduxFramework;

        public function __construct() {

            if (!class_exists('ReduxFramework')) {
                return;
            }

            // This is needed. Bah WordPress bugs.  ;)
            if (  true == Redux_Helpers::isTheme(__FILE__) ) {
                $this->initSettings();
            } else {
                add_action('plugins_loaded', array($this, 'initSettings'), 10);
            }

        }

        public function initSettings() {

            // Just for demo purposes. Not needed per say.
            $this->theme = wp_get_theme();

            // Set the default arguments
            $this->setArguments();

            // Set a few help tabs so you can see how it's done
            $this->setHelpTabs();

            // Create the sections and fields
            $this->setSections();

            if (!isset($this->args['opt_name'])) { // No errors please
                return;
            }

            // If Redux is running as a plugin, this will remove the demo notice and links
            //add_action( 'redux/loaded', array( $this, 'remove_demo' ) );
            
            // Function to test the compiler hook and demo CSS output.
            // Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
            //add_filter('redux/options/'.$this->args['opt_name'].'/compiler', array( $this, 'compiler_action' ), 10, 3);
            
            // Change the arguments after they've been declared, but before the panel is created
            //add_filter('redux/options/'.$this->args['opt_name'].'/args', array( $this, 'change_arguments' ) );
            
            // Change the default value of a field after it's been set, but before it's been useds
            //add_filter('redux/options/'.$this->args['opt_name'].'/defaults', array( $this,'change_defaults' ) );
            
            // Dynamically add a section. Can be also used to modify sections/fields
            //add_filter('redux/options/' . $this->args['opt_name'] . '/sections', array($this, 'dynamic_section'));

            $this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
        }

        /**

          This is a test function that will let you see when the compiler hook occurs.
          It only runs if a field	set with compiler=>true is changed.

         * */
        function compiler_action($options, $css, $changed_values) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r($changed_values); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }

        /**

          Custom function for filtering the sections array. Good for child themes to override or add to the sections.
          Simply include this function in the child themes functions.php file.

          NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
          so you must use get_template_directory_uri() if you want to use any of the built in icons

         * */
        function dynamic_section($sections) {
            //$sections = array();
            $sections[] = array(
                'title' => esc_html__('Section via hook', 'crown'),
                'desc' => esc_html__('<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'crown'),
                'icon' => 'el-icon-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }

        /**

          Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.

         * */
        function change_arguments($args) {
            //$args['dev_mode'] = true;

            return $args;
        }

        /**

          Filter hook for filtering the default value of any given field. Very useful in development mode.

         * */
        function change_defaults($defaults) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }

        // Remove the demo link and the notice of integrated demo from the redux-framework plugin
        function remove_demo() {

            // Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
            if (class_exists('ReduxFrameworkPlugin')) {
                remove_filter('plugin_row_meta', array(ReduxFrameworkPlugin::instance(), 'plugin_metalinks'), null, 2);

                // Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
                remove_action('admin_notices', array(ReduxFrameworkPlugin::instance(), 'admin_notices'));
            }
        }

        public function setSections() {

            /**
              Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
             * */
            // Background Patterns Reader
            $sample_patterns_path   = ReduxFramework::$_dir . '../sample/patterns/';
            $sample_patterns_url    = ReduxFramework::$_url . '../sample/patterns/';
            $sample_patterns        = array();

            if (is_dir($sample_patterns_path)) :

                if ($sample_patterns_dir = opendir($sample_patterns_path)) :
                    $sample_patterns = array();

                    while (( $sample_patterns_file = readdir($sample_patterns_dir) ) !== false) {

                        if (stristr($sample_patterns_file, '.png') !== false || stristr($sample_patterns_file, '.jpg') !== false) {
                            $name = explode('.', $sample_patterns_file);
                            $name = str_replace('.' . end($name), '', $sample_patterns_file);
                            $sample_patterns[]  = array('alt' => $name, 'img' => $sample_patterns_url . $sample_patterns_file);
                        }
                    }
                endif;
            endif;

            ob_start();

            $ct             = wp_get_theme();
            $this->theme    = $ct;
            $item_name      = $this->theme->get('Name');
            $tags           = $this->theme->Tags;
            $screenshot     = $this->theme->get_screenshot();
            $class          = $screenshot ? 'has-screenshot' : '';

            $customize_title = sprintf(esc_html__('Customize &#8220;%s&#8221;', 'crown'), $this->theme->display('Name'));
            
            ?>
            <div id="current-theme" class="<?php echo esc_attr($class); ?>">
            <?php if ($screenshot) : ?>
                <?php if (current_user_can('edit_theme_options')) : ?>
                        <a href="<?php echo wp_customize_url(); ?>" class="load-customize hide-if-no-customize" title="<?php echo esc_attr($customize_title); ?>">
                            <img src="<?php echo esc_url($screenshot); ?>" alt="<?php esc_attr_e('Current theme preview', 'crown'); ?>" />
                        </a>
                <?php endif; ?>
                    <img class="hide-if-customize" src="<?php echo esc_url($screenshot); ?>" alt="<?php esc_attr_e('Current theme preview', 'crown'); ?>" />
                <?php endif; ?>

                <h4><?php echo esc_html($this->theme->display('Name')); ?></h4>

                <div>
                    <ul class="theme-info">
                        <li><?php printf(esc_html__('By %s', 'crown'), $this->theme->display('Author')); ?></li>
                        <li><?php printf(esc_html__('Version %s', 'crown'), $this->theme->display('Version')); ?></li>
                        <li><?php echo '<strong>' . esc_html__('Tags', 'crown') . ':</strong> '; ?><?php printf($this->theme->display('Tags')); ?></li>
                    </ul>
                    <p class="theme-description"><?php echo esc_html($this->theme->display('Description')); ?></p>
            <?php
            if ($this->theme->parent()) {
                printf(' <p class="howto">' . esc_html__('This <a href="%1$s">child theme</a> requires its parent theme, %2$s.', 'crown') . '</p>', esc_html__('http://codex.wordpress.org/Child_Themes', 'crown'), $this->theme->parent()->display('Name'));
            }
            ?>

                </div>
            </div>

            <?php
            $item_info = ob_get_contents();

            ob_end_clean();

            $sampleHTML = '';
           $form_options = array();
			if(class_exists('WYSIJA')){
				$wysija_model_forms = WYSIJA::get('forms', 'model');
				$wysija_forms = $wysija_model_forms->getRows();
				foreach($wysija_forms as $wysija_form){
					$form_options[$wysija_form['form_id']] = esc_html($wysija_form['name']);
				}
			}
			
            // General
            $this->sections[] = array(
                'title'     => esc_html__('General', 'crown'),
                'desc'      => esc_html__('General theme options', 'crown'),
                'icon'      => 'el-icon-cog',
                'fields'    => array(

                    array(
                        'id'        => 'logo_main',
                        'type'      => 'media',
                        'title'     => esc_html__('Logo', 'crown'),
                        'compiler'  => 'true',
                        'mode'      => false,
                        'desc'      => esc_html__('Upload logo here.', 'crown'),
                    ),
					array(
                        'id'        => 'opt-favicon',
                        'type'      => 'media',
                        'title'     => esc_html__('Favicon', 'crown'),
                        'compiler'  => 'true',
                        'mode'      => false,
                        'desc'      => esc_html__('Upload favicon here.', 'crown'),
                    ),
					array(
                        'id'        => 'background_opt',
                        'type'      => 'background',
                        'output'    => array('body'),
                        'title'     => esc_html__('Body background', 'crown'),
                        'subtitle'  => esc_html__('Upload image or select color. Only work with box layout', 'crown'),
						'default'   => array('background-color' => '#fff'),
                    ),
					array(
                        'id'        => 'back_to_top',
                        'type'      => 'switch',
                        'title'     => esc_html__('Back To Top', 'crown'),
						'desc'      => esc_html__('Show back to top button on all pages', 'crown'),
						'default'   => true,
                    ),
                ),
            );
			
			// Colors
            $this->sections[] = array(
                'title'     => esc_html__('Colors', 'crown'),
                'desc'      => esc_html__('Color options', 'crown'),
                'icon'      => 'el-icon-tint',
                'fields'    => array(
					array(
                        'id'        => 'primary_color',
                        'type'      => 'color',
                        'title'     => esc_html__('Primary Color', 'crown'),
                        'subtitle'  => esc_html__('Pick a color for primary color (default: #ba933e).', 'crown'),
						'transparent' => false,
                        'default'   => '#79cba8',
                        'validate'  => 'color',
                    ),
					
					array(
                        'id'        => 'sale_color',
                        'type'      => 'color',
                        //'output'    => array(),
                        'title'     => esc_html__('Sale Label BG Color', 'crown'),
                        'subtitle'  => esc_html__('Pick a color for bg sale label (default: #fff).', 'crown'),
						'transparent' => true,
                        'default'   => '#fff',
                        'validate'  => 'color',
                    ),
					
					array(
                        'id'        => 'saletext_color',
                        'type'      => 'color',
                        //'output'    => array(),
                        'title'     => esc_html__('Sale Label Text Color', 'crown'),
                        'subtitle'  => esc_html__('Pick a color for sale label text (default: #ffffff).', 'crown'),
						'transparent' => false,
                        'default'   => '#ffffff',
                        'validate'  => 'color',
                    ),
					
					array(
                        'id'        => 'rate_color',
                        'type'      => 'color',
                        //'output'    => array(),
                        'title'     => esc_html__('Rating Star Color', 'crown'),
                        'subtitle'  => esc_html__('Pick a color for star of rating (default: #181818).', 'crown'),
						'transparent' => false,
                        'default'   => '#181818',
                        'validate'  => 'color',
                    ),
                ),
            );
			
			//Header
			$this->sections[] = array(
                'title'     => esc_html__('Header', 'crown'),
                'desc'      => esc_html__('Header options', 'crown'),
                'icon'      => 'el-icon-tasks',
                'fields'    => array(
					array(
                        'id'        => 'hotline',
                        'type'      => 'text',
                        'title'     => esc_html__('Hotline', 'crown'),
                        'default'   => 'Tel. +84 123456789 '
                    ),
					array(
                        'id'        => 'work_time',
                        'type'      => 'text',
                        'title'     => esc_html__('Work time', 'crown'),
                        'default'   => 'WORK TIME. Monday - Friday: 8Am - 5Pm'
                    ),
					array(
                        'id'        => 'header_layout',
                        'type'      => 'select',
                        'title'     => esc_html__('Header Layout', 'crown'),

                        //Must provide key => value pairs for select options
                        'options'   => array(
                            'default' => 'Default',
                            'second' => 'Second',
                        ),
                        'default'   => 'default'
                    ),
                ),
            );
			
			   
			//Footer
			$this->sections[] = array(
                'title'     => esc_html__('Footer', 'crown'),
                'desc'      => esc_html__('Footer options', 'crown'),
                'icon'      => 'el-icon-cog',
                'fields'    => array(
					array(
                        'id'        => 'footer_layout',
                        'type'      => 'select',
                        'title'     => esc_html__('Footer Layout', 'crown'),
                        'options'   => array(
                            'default' => 'Default',
							'second' => 'Second',
                        ),
                        'default'   => 'default'
                    ),
					array(
                        'id'        => 'newsletter_form',
                        'type'      => 'select',
                        'title'     => esc_html__('Newsletter Form', 'crown'),
						'options'   => $form_options,
                    ),
					array(
						'id'               => 'copyright',
						'type'             => 'editor',
						'title'    => esc_html__('Copyright information', 'crown'),
						'subtitle'         => esc_html__('HTML tags allowed: a, br, em, strong', 'crown'),
						'default'          => 'Copyright &copy; 2016 Crownthemes All Rights Reserved.',
						'args'   => array(
							'teeny'            => true,
							'textarea_rows'    => 5,
							'media_buttons'	=> false,
						)
					),
                ),
            );
			$this->sections[] = array(
				'icon'       => 'el-icon-website',
				'title'      => esc_html__( 'Instagram', 'crown' ),
				'subsection' => true,
				'fields'     => array(
					array(
						'id'        => 'instagram_title',
						'type'      => 'text',
						'title'     => esc_html__('Instagram title', 'crown'),
						'default'   => 'Instagram'
					),
					array(
						'id'        => 'instagram_shortcode',
						'type'      => 'text',
						'title'     => esc_html__('Instagram shortcode', 'crown'),
						'desc'      => esc_html__('Shortcode to show instagram feed, plugin url: https://wordpress.org/plugins/instagram-feed/', 'crown'),
						'default'   => '[instagram-feed id="269801886"]'
					),
				)
			);
			
			$this->sections[] = array(
				'icon'       => 'el-icon-website',
				'title'      => esc_html__( 'About Us', 'crown' ),
				'subsection' => true,
				'fields'     => array(

					array(
						'id'=>'about_us',
						'type' => 'editor',
						'title' => esc_html__('About Us', 'crown'), 
						'subtitle'         => esc_html__('HTML tags allowed: a, img, br, em, strong, p, ul, li', 'crown'),
						'default' => '
							<div class="logo-footer">
						<h3>Crown</h3>
						<em>126 Canterbury Road, Victoria Street, 3237, Sidney, Australia</em>

						</div>
						<div class="ft-contactus">
							<p class="phone"><em>Telephone:</em> +01 234 567 89</p>
							<p class="email"><em>Email:</em> info@thebuesky.com</p>
						</div>',
						'args'   => array(
							'teeny'            => true,
							'textarea_rows'    => 10
						)
					),
				)
			);
			$this->sections[] = array(
				'icon'       => 'el-icon-website',
				'title'      => esc_html__( 'Social Icons', 'crown' ),
				'subsection' => true,
				'fields'     => array(				 
				 array(
				  'id'       => 'social_icons',
				  'type'     => 'sortable',
				  'title'    => esc_html__('Social Icons', 'crown'),
				  'subtitle' => esc_html__('Enter social links', 'crown'),
				  'desc'     => esc_html__('Drag/drop to re-arrange', 'crown'),
				  'mode'     => 'text',
				  'options'  => array(
					'twitter'     => '',
					'skype'     => '',
					'vine'     => '',
					'facebook'     => '',
					'instagram' => '',
					'tumblr'     => '',
					'pinterest'     => '',
					'google-plus'     => '',
					'linkedin'     => '',
					'behance'     => '',
					'dribbble'     => '',
					'youtube'     => '',				   
					'rss'     => '',
					'vk'     => '',
					'yahoo'     => '',
					'qq'     => '',				   
					'weibo'     => '',
				  ),
				  'default' => array(					 
					   'twitter'     => '#twitter.com',
					   'skype'     => '#skype',
					   'vine'     => '#vine',				   
					   'facebook'     => '#facebook',
				  ),
				 ),
				)
			);
            $this->sections[] = array(
                'icon'       => 'el-icon-website',
                'title'      => esc_html__( 'Menus', 'crown' ),
                'subsection' => true,
                'fields'     => array(
                    array(
                        'id'       => 'footer_menu1',
                        'type'     => 'select',
                        'data'     => 'menus',
                        'title'    => esc_html__( 'Menu #1', 'crown' ),
                        'subtitle' => esc_html__( 'Select a menu', 'crown' ),
                    ),
                )
            );
			
			//Newsletter Popup
			$this->sections[] = array(
				'icon'       => 'el-icon-website',
				'title'      => esc_html__( 'Newsletter Popup', 'crown' ),
				'desc'      => esc_html__('Content show up on home page loaded', 'crown'),
				'fields'     => array(
					array(
                        'id'        => 'enable_popup',
                        'type'      => 'switch',
                        'title'     => esc_html__('Enable', 'crown'),
						'default'   => true,
                    ),
					array(
                        'id'        => 'background_popup',
                        'type'      => 'background',
                        'output'    => array(''),
                        'title'     => esc_html__('Popup background', 'crown'),
                        'subtitle'  => esc_html__('Upload image or select color.', 'crown'),
						'default'   => array('background-color' => '#eee'),
                    ),
					array(
						'id'=>'popup_onload_content',
						'type' => 'editor',
						'title' => esc_html__('Content', 'crown'), 
						'subtitle'         => esc_html__('HTML tags allowed: a, img, br, em, strong, p, ul, li', 'crown'),
						'default' => '<h3>Newsletter</h3>
									Subscribe to the Crown mailing list to receive updates on new arrivals, special offers
									and other discount information.',
						'args'   => array(
							'teeny'            => true,
							'textarea_rows'    => 10,
							'media_buttons'	=> true,
						)
					),
					array(
                        'id'        => 'popup_onload_form',
                        'type'      => 'select',
                        'title'     => esc_html__('Newsletter Form', 'crown'),
						'options'   => $form_options,
                    ),
					array(
						'id'        => 'popup_onload_expires',
						'type'      => 'slider',
						'title'     => esc_html__('Time expires', 'crown'),
						'desc'      => esc_html__('Time expires after tick not show again defaut: 7 days', 'crown'),
						'default'   => 1,
						'min'       => 1,
						'step'      => 1,
						'max'       => 7,
						'display_value' => 'text'
					),
				)
			);
			
			//Fonts
			$this->sections[] = array(
                'title'     => esc_html__('Fonts', 'crown'),
                'desc'      => esc_html__('Fonts options', 'crown'),
                'icon'      => 'el-icon-font',
                'fields'    => array(

                    array(
                        'id'            => 'bodyfont',
                        'type'          => 'typography',
                        'title'         => esc_html__('Body font', 'crown'),
                        //'compiler'      => true,  // Use if you want to hook in your own CSS compiler
                        'google'        => true,    // Disable google fonts. Won't work if you haven't defined your google api key
                        'font-backup'   => false,    // Select a backup non-google font in addition to a google font
                        //'font-style'    => false, // Includes font-style and weight. Can use font-style or font-weight to declare
                        'subsets'       => false, // Only appears if google is true and subsets not set to false
						'text-align'   => false,
                        //'font-size'     => false,
                        //'line-height'   => false,
                        //'word-spacing'  => true,  // Defaults to false
                        //'letter-spacing'=> true,  // Defaults to false
                        //'color'         => false,
                        //'preview'       => false, // Disable the previewer
                        'all_styles'    => true,    // Enable all Google Font style/weight variations to be added to the page
                        'output'        => array('body'), // An array of CSS selectors to apply this font style to dynamically
                        //'compiler'      => array('h2.site-description-compiler'), // An array of CSS selectors to apply this font style to dynamically
                        'units'         => 'px', // Defaults to px
                        'subtitle'      => esc_html__('Main body font.', 'crown'),
                        'default'       => array(
                            'color'         => '#aaaaaa',
                            'font-weight'    => '400',
                            'font-family'   => 'Lora',
                            'google'        => true,
                            'font-size'     => '14px',
                            'line-height'   => '22px'
						),
                    ),
					array(
                        'id'        => 'use_design_bodyfont',
                        'type'      => 'switch',
                        'title'     => esc_html__('Use design font for body', 'crown'),
						'default'   => false,
                    ),
					array(
                        'id'            => 'headingfont',
                        'type'          => 'typography',
                        'title'         => esc_html__('Heading font', 'crown'),
                        //'compiler'      => true,  // Use if you want to hook in your own CSS compiler
                        'google'        => true,    // Disable google fonts. Won't work if you haven't defined your google api key
                        'font-backup'   => false,    // Select a backup non-google font in addition to a google font
                        //'font-style'    => false, // Includes font-style and weight. Can use font-style or font-weight to declare
                        'subsets'       => false, // Only appears if google is true and subsets not set to false
                        'font-size'     => false,
                        'line-height'   => false,
						'text-align'   => false,
                        //'word-spacing'  => true,  // Defaults to false
                        //'letter-spacing'=> true,  // Defaults to false
                        //'color'         => false,
                        //'preview'       => false, // Disable the previewer
                        'all_styles'    => true,    // Enable all Google Font style/weight variations to be added to the page
                        //'output'        => array('h1, h2, h3, h4, h5, h6'), // An array of CSS selectors to apply this font style to dynamically
                        //'compiler'      => array('h2.site-description-compiler'), // An array of CSS selectors to apply this font style to dynamically
                        'units'         => 'px', // Defaults to px
                        'subtitle'      => esc_html__('Heading font.', 'crown'),
                        'default'       => array(
							'color'         => '#222222',
                            'font-weight'    => '700',
                            'font-family'   => 'Lora',
                            'google'        => false,
						),
                    ),
					array(
                        'id'        => 'use_design_headingfont',
                        'type'      => 'switch',
                        'title'     => esc_html__('Use design font for heading', 'crown'),
						'default'   => true,
                    ),
					array(
                        'id'            => 'menufont',
                        'type'          => 'typography',
                        'title'         => esc_html__('Menu font', 'crown'),
                        //'compiler'      => true,  // Use if you want to hook in your own CSS compiler
                        'google'        => true,    // Disable google fonts. Won't work if you haven't defined your google api key
                        'font-backup'   => false,    // Select a backup non-google font in addition to a google font
                        //'font-style'    => false, // Includes font-style and weight. Can use font-style or font-weight to declare
                        'subsets'       => false, // Only appears if google is true and subsets not set to false
                        'font-size'     => true,
                        'line-height'   => false,
						'text-align'   => false,
						'color'         => true,
                        //'word-spacing'  => true,  // Defaults to false
                        //'letter-spacing'=> true,  // Defaults to false
                        //'color'         => false,
                        //'preview'       => false, // Disable the previewer
                        'all_styles'    => true,    // Enable all Google Font style/weight variations to be added to the page
                        //'output'        => array('h1, h2, h3, h4, h5, h6'), // An array of CSS selectors to apply this font style to dynamically
                        //'compiler'      => array('h2.site-description-compiler'), // An array of CSS selectors to apply this font style to dynamically
                        'units'         => 'px', // Defaults to px
                        'subtitle'      => esc_html__('Menu font.', 'crown'),
                        'default'       => array(
                            'font-weight'    => '400',
                            'font-family'   => 'Lora',
							'font-size'     => '14px',
                            'google'        => false,
							'color'			=> '#111111',
						),
                    ),
					array(
                        'id'        => 'use_design_menufont',
                        'type'      => 'switch',
                        'title'     => esc_html__('Use design font for menu', 'crown'),
						'default'   => true,
                    ),
					array(
                        'id'        => 'sub_menu_bg',
                        'type'      => 'color',
                        //'output'    => array(),
                        'title'     => esc_html__('Submenu background', 'crown'),
                        'subtitle'  => esc_html__('Pick a color for sub menu bg (default: #fff).', 'crown'),
						'transparent' => false,
                        'default'   => '#fff',
                        'validate'  => 'color',
                    ),
                ),
            );
			
			// Layout
            $this->sections[] = array(
                'title'     => esc_html__('Layout', 'crown'),
                'desc'      => esc_html__('Select page layout: Box or Full Width', 'crown'),
                'icon'      => 'el-icon-align-justify',
                'fields'    => array(
					array(
						'id'       => 'page_layout',
						'type'     => 'select',
						'multi'    => false,
						'title'    => esc_html__('Page Layout', 'crown'),
						'options'  => array(
							'full' => 'Full Width',
							'box' => 'Box'
						),
						'default'  => 'full'
					),
					array(
						'id'        => 'box_layout_width',
						'type'      => 'slider',
						'title'     => esc_html__('Box layout width', 'crown'),
						'desc'      => esc_html__('Box layout width in pixels, default value: 1200', 'crown'),
						"default"   => 1200,
						"min"       => 960,
						"step"      => 1,
						"max"       => 1920,
						'display_value' => 'text'
					),
                ),
            );
			
			//Brand logos
			$this->sections[] = array(
                'title'     => esc_html__('Brand Logos', 'crown'),
                'desc'      => esc_html__('Upload brand logos and links', 'crown'),
                'icon'      => 'el-icon-briefcase',
                'fields'    => array(
					array(
						'id'          => 'brand_logos_1',
						'type'        => 'slides',
						'title'       => esc_html__('List Logo 1', 'crown'),
						'desc'        => esc_html__('Upload logo image and enter logo link.', 'crown'),
						'placeholder' => array(
							'title'           => esc_html__('Title', 'crown'),
							'description'     => esc_html__('Description', 'crown'),
							'url'             => esc_html__('Link', 'crown'),
						),
					),
					array(
						'id'          => 'brand_logos_2',
						'type'        => 'slides',
						'title'       => esc_html__('List Logo 2', 'crown'),
						'desc'        => esc_html__('Upload logo image and enter logo link.', 'crown'),
						'placeholder' => array(
							'title'           => esc_html__('Title', 'crown'),
							'description'     => esc_html__('Description', 'crown'),
							'url'             => esc_html__('Link', 'crown'),
						),
					),
                ),
            );
			
			// Sidebar
			$this->sections[] = array(
                'title'     => esc_html__('Sidebar', 'crown'),
                'desc'      => esc_html__('Sidebar options', 'crown'),
                'icon'      => 'el-icon-cog',
                'fields'    => array(
					
					array(
						'id'       => 'sidebarshop_pos',
						'type'     => 'radio',
						'title'    => esc_html__('Shop Sidebar Position', 'crown'),
						'subtitle'      => esc_html__('Sidebar on shop page', 'crown'),
						'options'  => array(
							'left' => 'Left',
							'right' => 'Right'),
						'default'  => 'left'
					),
					array(
						'id'       => 'sidebarse_pos',
						'type'     => 'radio',
						'title'    => esc_html__('Pages Sidebar Position', 'crown'),
						'subtitle'      => esc_html__('Sidebar on pages', 'crown'),
						'options'  => array(
							'left' => 'Left',
							'right' => 'Right'),
						'default'  => 'left'
					),
					array(
						'id'       => 'sidebarblog_pos',
						'type'     => 'radio',
						'title'    => esc_html__('Blog Sidebar Position', 'crown'),
						'subtitle'      => esc_html__('Sidebar on Blog pages', 'crown'),
						'options'  => array(
							'left' => 'Left',
							'right' => 'Right'),
						'default'  => 'left'
					)
                ),
            );
			
			// Portfolio
            $this->sections[] = array(
                'title'     => esc_html__('Portfolio', 'crown'),
                'desc'      => esc_html__('Use this section to select options for portfolio', 'crown'),
                'icon'      => 'el-icon-bookmark',
                'fields'    => array(
					array(
						'id'        => 'portfolio_columns',
						'type'      => 'slider',
						'title'     => esc_html__('Portfolio Columns', 'crown'),
						"default"   => 3,
						"min"       => 2,
						"step"      => 1,
						"max"       => 4,
						'display_value' => 'text'
					),
					array(
						'id'        => 'portfolio_per_page',
						'type'      => 'slider',
						'title'     => esc_html__('Projects per page', 'crown'),
						'desc'      => esc_html__('Amount of projects per page on portfolio page', 'crown'),
						"default"   => 12,
						"min"       => 4,
						"step"      => 1,
						"max"       => 48,
						'display_value' => 'text'
					),
					array(
                        'id'        => 'related_project_title',
                        'type'      => 'text',
                        'title'     => esc_html__('Related projects title', 'crown'),
                        'default'   => 'Related Projects'
                    ),
                ),
            );
			
			// Product
            $this->sections[] = array(
                'title'     => esc_html__('Product', 'crown'),
                'desc'      => esc_html__('Use this section to select options for product', 'crown'),
                'icon'      => 'el-icon-tags',
                'fields'    => array(
					array(
                        'id'        => 'shop_layout',
                        'type'      => 'select',
                        'title'     => esc_html__('Shop Layout', 'crown'),
                        'options'   => array(
							'sidebar' => 'Sidebar',
                            'fullwidth' => 'Full Width',
                        ),
                        'default'   => 'sidebar'
                    ),
					array(
                        'id'        => 'default_view',
                        'type'      => 'select',
                        'title'     => esc_html__('Shop default view', 'crown'),
                        'options'   => array(
							'grid-view' => 'Grid View',
                            'list-view' => 'List View',
                        ),
                        'default'   => 'grid-view'
                    ),
					array(
						'id'        => 'product_per_page',
						'type'      => 'slider',
						'title'     => esc_html__('Products per page', 'crown'),
						'subtitle'      => esc_html__('Amount of products per page on category page', 'crown'),
						"default"   => 12,
						"min"       => 4,
						"step"      => 1,
						"max"       => 48,
						'display_value' => 'text'
					),
					array(
						'id'        => 'product_per_row',
						'type'      => 'slider',
						'title'     => esc_html__('Product columns', 'crown'),
						'subtitle'      => esc_html__('Amount of product columns on category page', 'crown'),
						'desc'      => esc_html__('Only works with: 1, 2, 3, 4, 6', 'crown'),
						"default"   => 3,
						"min"       => 1,
						"step"      => 1,
						"max"       => 6,
						'display_value' => 'text'
					),
					array(
						'id'        => 'product_per_row_fw',
						'type'      => 'slider',
						'title'     => esc_html__('Product columns on full width shop', 'crown'),
						'subtitle'      => esc_html__('Amount of product columns on full width category page', 'crown'),
						'desc'      => esc_html__('Only works with: 1, 2, 3, 4, 6', 'crown'),
						"default"   => 4,
						"min"       => 1,
						"step"      => 1,
						"max"       => 6,
						'display_value' => 'text'
					),
					array(
						'id'       => 'second_image',
						'type'     => 'switch',
						'title'    => esc_html__('Use secondary product image', 'crown'),
						'desc'      => esc_html__('Show the secondary image when hover on product on list', 'crown'),
						'default'  => true,
					),
					array(
                        'id'        => 'new_pro_from',
                        'type'      => 'text',
                        'title'     => esc_html__('New product from', 'crown'),
						'desc'      => esc_html__('This set a day to mark product as new from that day to now. Blank for not set.', 'crown'),
                        'default'   => ''
                    ),
					array(
                        'id'        => 'new_pro_label',
                        'type'      => 'text',
                        'title'     => esc_html__('New label', 'crown'),
                        'default'   => 'New'
                    ),
					array(
                        'id'        => 'featured_pro_label',
                        'type'      => 'text',
                        'title'     => esc_html__('Featured label', 'crown'),
                        'default'   => 'Hot'
                    ),
					array(
                        'id'        => 'upsells_title',
                        'type'      => 'text',
                        'title'     => esc_html__('Up-Sells title', 'crown'),
                        'default'   => 'Up-Sells'
                    ),
					array(
                        'id'        => 'crosssells_title',
                        'type'      => 'text',
                        'title'     => esc_html__('Cross-Sells title', 'crown'),
                        'default'   => 'Cross-Sells'
                    ),
                ),
            );
			$this->sections[] = array(
				'icon'       => 'el-icon-website',
				'title'      => esc_html__( 'Product page', 'crown' ),
				'subsection' => true,
				'fields'     => array(
					array(
                        'id'        => 'related_title',
                        'type'      => 'text',
                        'title'     => esc_html__('Related products title', 'crown'),
                        'default'   => 'Related Products'
                    ),
					array(
						'id'        => 'related_amount',
						'type'      => 'slider',
						'title'     => esc_html__('Number of related products', 'crown'),
						"default"   => 4,
						"min"       => 1,
						"step"      => 1,
						"max"       => 16,
						'display_value' => 'text'
					),
					array(
                        'id'        => 'upsells_title',
                        'type'      => 'text',
                        'title'     => esc_html__('Up-Sells title', 'crown'),
                        'default'   => 'Up-Sells'
                    ),
				)
			);
			$this->sections[] = array(
				'icon'       => 'el-icon-website',
				'title'      => esc_html__( 'Quick View', 'crown' ),
				'subsection' => true,
				'fields'     => array(
					array(
                        'id'        => 'detail_link_text',
                        'type'      => 'text',
                        'title'     => esc_html__('View details text', 'crown'),
                        'default'   => 'View details'
                    ),
					array(
                        'id'        => 'quickview_link_text',
                        'type'      => 'text',
                        'title'     => esc_html__('View all features text', 'crown'),
						'desc'      => esc_html__('This is the text on quick view box', 'crown'),
                        'default'   => 'See all features'
                    ),
				)
			);
			// Blog options
            $this->sections[] = array(
                'title'     => esc_html__('Blog', 'crown'),
                'desc'      => esc_html__('Use this section to select options for blog', 'crown'),
                'icon'      => 'el-icon-file',
                'fields'    => array(
					array(
                        'id'        => 'blog_header_text',
                        'type'      => 'text',
                        'title'     => esc_html__('Blog header text', 'crown'),
                        'default'   => 'Blog'
                    ),
					array(
                        'id'        => 'blog_header_subtext',
                        'type'      => 'text',
                        'title'     => esc_html__('Blog header sub-text', 'crown'),
                        'default'   => 'Text of the printing and typesetting industry'
                    ),
					array(
                        'id'        => 'blog_header_bg',
                        'type'      => 'background',
                        'output'    => array('body.blog header.blog-entry-header'),
                        'title'     => esc_html__('Blog header background', 'crown'),
						'default'   => array('background-color' => '#ddd'),
                    ),
					array(
                        'id'        => 'blog_layout',
                        'type'      => 'select',
                        'title'     => esc_html__('Blog Layout', 'crown'),
                        'options'   => array(
							'nosidebar' => 'No Sidebar',
							'sidebar' => 'Sidebar',
                        ),
                        'default'   => 'nosidebar'
                    ),
					array(
                        'id'        => 'blog_column',
                        'type'      => 'select',
                        'title'     => esc_html__('Blog Content Column', 'crown'),
                        'options'   => array(
							12 => 'One Column',
							6 => 'Two Column',
							4 => 'Three Column',
							3 => 'Four Column'
                        ),
                        'default'   => 6
                    ),
					array(
                        'id'        => 'readmore_text',
                        'type'      => 'text',
                        'title'     => esc_html__('Read more text', 'crown'),
                        'default'   => 'read more'
                    ),
					array(
						'id'        => 'excerpt_length',
						'type'      => 'slider',
						'title'     => esc_html__('Excerpt length on blog page', 'crown'),
						"default"   => 15,
						"min"       => 10,
						"step"      => 2,
						"max"       => 120,
						'display_value' => 'text'
					),
                ),
            );
			
			// Error 404 page
            $this->sections[] = array(
                'title'     => esc_html__('Error 404 Page', 'crown'),
                'desc'      => esc_html__('Error 404 page options', 'crown'),
                'icon'      => 'el-icon-cog',
                'fields'    => array(
					array(
                        'id'        => 'background_error',
                        'type'      => 'background',
                        'output'    => array('body.error404'),
                        'title'     => esc_html__('Error 404 background', 'crown'),
                        'subtitle'  => esc_html__('Upload image or select color.', 'crown'),
						'default'   => array('background-color' => ''),
                    ),
					array(
                        'id'        => '404-content',
                        'type'      => 'editor',
                        'title'     => esc_html__('404 Content', 'crown'),
						'default' => '<h3>Component not found</h3>
									<h2>Oh my gosh! You found it!!!</h2>
									<p>The page are looking for has moved or does not exist anymore, If you like you can return our homepage.<br/>If the problem persists, please send us a email to <a href="mailto:lionthemes88@gmail.com">lionthemes88@gmail.com</a></p>',
						'args'   => array(
							'teeny'            => true,
							'textarea_rows'    => 10,
							'media_buttons'	=> true,
						)
                    ),
                ),
            );
			
			// Custom CSS
            $this->sections[] = array(
                'title'     => esc_html__('Custom CSS', 'crown'),
                'desc'      => esc_html__('Add your Custom CSS code', 'crown'),
                'icon'      => 'el-icon-pencil',
                'fields'    => array(
					array(
						'id'       => 'custom_css',
						'type'     => 'ace_editor',
						'title'    => esc_html__('CSS Code', 'crown'),
						'subtitle' => esc_html__('Paste your CSS code here.', 'crown'),
						'mode'     => 'css',
						'theme'    => 'monokai', //chrome
						'default'  => ""
					),
                ),
            );
			
			// Less Compiler
            $this->sections[] = array(
                'title'     => esc_html__('Less Compiler', 'crown'),
                'desc'      => esc_html__('Turn on this option to apply all theme options. Turn of when you have finished changing theme options and your site is ready.', 'crown'),
                'icon'      => 'el-icon-wrench',
                'fields'    => array(
					array(
                        'id'        => 'enable_less',
                        'type'      => 'switch',
                        'title'     => esc_html__('Enable Less Compiler', 'crown'),
						'default'   => true,
                    ),
                ),
            );
			
            $theme_info  = '<div class="redux-framework-section-desc">';
            $theme_info .= '<p class="redux-framework-theme-data description theme-uri">' . esc_html__('<strong>Theme URL:</strong> ', 'crown') . '<a href="' . esc_url($this->theme->get('ThemeURI')) . '" target="_blank">' . $this->theme->get('ThemeURI') . '</a></p>';
            $theme_info .= '<p class="redux-framework-theme-data description theme-author">' . esc_html__('<strong>Author:</strong> ', 'crown') . $this->theme->get('Author') . '</p>';
            $theme_info .= '<p class="redux-framework-theme-data description theme-version">' . esc_html__('<strong>Version:</strong> ', 'crown') . $this->theme->get('Version') . '</p>';
            $theme_info .= '<p class="redux-framework-theme-data description theme-description">' . $this->theme->get('Description') . '</p>';
            $tabs = $this->theme->get('Tags');
            if (!empty($tabs)) {
                $theme_info .= '<p class="redux-framework-theme-data description theme-tags">' . esc_html__('<strong>Tags:</strong> ', 'crown') . implode(', ', $tabs) . '</p>';
            }
            $theme_info .= '</div>';

            $this->sections[] = array(
                'title'     => esc_html__('Import / Export', 'crown'),
                'desc'      => esc_html__('Import and Export your Redux Framework settings from file, text or URL.', 'crown'),
                'icon'      => 'el-icon-refresh',
                'fields'    => array(
                    array(
                        'id'            => 'opt-import-export',
                        'type'          => 'import_export',
                        'title'         => 'Import Export',
                        'subtitle'      => 'Save and restore your Redux options',
                        'full_width'    => false,
                    ),
                ),
            );

            $this->sections[] = array(
                'icon'      => 'el-icon-info-sign',
                'title'     => esc_html__('Theme Information', 'crown'),
                //'desc'      => esc_html__('<p class="description">This is the Description. Again HTML is allowed</p>', 'crown'),
                'fields'    => array(
                    array(
                        'id'        => 'opt-raw-info',
                        'type'      => 'raw',
                        'content'   => $item_info,
                    )
                ),
            );
        }

        public function setHelpTabs() {

            // Custom page help tabs, displayed using the help API. Tabs are shown in order of definition.
            $this->args['help_tabs'][] = array(
                'id'        => 'redux-help-tab-1',
                'title'     => esc_html__('Theme Information 1', 'crown'),
                'content'   => esc_html__('<p>This is the tab content, HTML is allowed.</p>', 'crown')
            );

            $this->args['help_tabs'][] = array(
                'id'        => 'redux-help-tab-2',
                'title'     => esc_html__('Theme Information 2', 'crown'),
                'content'   => esc_html__('<p>This is the tab content, HTML is allowed.</p>', 'crown')
            );

            // Set the help sidebar
            $this->args['help_sidebar'] = esc_html__('<p>This is the sidebar content, HTML is allowed.</p>', 'crown');
        }

        /**

          All the possible arguments for Redux.
          For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments

         * */
        public function setArguments() {

            $theme = wp_get_theme(); // For use with some settings. Not necessary.

            $this->args = array(
                // TYPICAL -> Change these values as you need/desire
                'opt_name'          => 'crown_opt',            // This is where your data is stored in the database and also becomes your global variable name.
                'display_name'      => $theme->get('Name'),     // Name that appears at the top of your panel
                'display_version'   => $theme->get('Version'),  // Version that appears at the top of your panel
                'menu_type'         => 'menu',                  //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
                'allow_sub_menu'    => true,                    // Show the sections below the admin menu item or not
                'menu_title'        => esc_html__('Theme Options', 'crown'),
                'page_title'        => esc_html__('Theme Options', 'crown'),
                
                // You will need to generate a Google API key to use this feature.
                // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
                'google_api_key' => '', // Must be defined to add google fonts to the typography module
                
                'async_typography'  => true,                    // Use a asynchronous font on the front end or font string
                //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
                'admin_bar'         => true,                    // Show the panel pages on the admin bar
                'global_variable'   => '',                      // Set a different name for your global variable other than the opt_name
                'dev_mode'          => false,                    // Show the time the page took to load, etc
                'customizer'        => true,                    // Enable basic customizer support
                //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
                //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field

                // OPTIONAL -> Give you extra features
                'page_priority'     => null,                    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
                'page_parent'       => 'themes.php',            // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
                'page_permissions'  => 'manage_options',        // Permissions needed to access the options panel.
                'menu_icon'         => '',                      // Specify a custom URL to an icon
                'last_tab'          => '',                      // Force your panel to always open to a specific tab (by id)
                'page_icon'         => 'icon-themes',           // Icon displayed in the admin panel next to your menu_title
                'page_slug'         => '_options',              // Page slug used to denote the panel
                'save_defaults'     => true,                    // On load save the defaults to DB before user clicks save or not
                'default_show'      => false,                   // If true, shows the default value next to each field that is not the default value.
                'default_mark'      => '',                      // What to print by the field's title if the value shown is default. Suggested: *
                'show_import_export' => true,                   // Shows the Import/Export panel when not used as a field.
                
                // CAREFUL -> These options are for advanced use only
                'transient_time'    => 60 * MINUTE_IN_SECONDS,
                'output'            => true,                    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
                'output_tag'        => true,                    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
                // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.
                
                // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
                'database'              => '', // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
                'system_info'           => false, // REMOVE

                // HINTS
                'hints' => array(
                    'icon'          => 'icon-question-sign',
                    'icon_position' => 'right',
                    'icon_color'    => 'lightgray',
                    'icon_size'     => 'normal',
                    'tip_style'     => array(
                        'color'         => 'light',
                        'shadow'        => true,
                        'rounded'       => false,
                        'style'         => '',
                    ),
                    'tip_position'  => array(
                        'my' => 'top left',
                        'at' => 'bottom right',
                    ),
                    'tip_effect'    => array(
                        'show'          => array(
                            'effect'        => 'slide',
                            'duration'      => '500',
                            'event'         => 'mouseover',
                        ),
                        'hide'      => array(
                            'effect'    => 'slide',
                            'duration'  => '500',
                            'event'     => 'click mouseleave',
                        ),
                    ),
                )
            );

            // SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
            $this->args['share_icons'][] = array(
                'url'   => 'https://github.com/ReduxFramework/ReduxFramework',
                'title' => 'Visit us on GitHub',
                'icon'  => 'el-icon-github'
                //'img'   => '', // You can use icon OR img. IMG needs to be a full URL.
            );
            $this->args['share_icons'][] = array(
                'url'   => 'https://www.facebook.com/pages/Redux-Framework/243141545850368',
                'title' => 'Like us on Facebook',
                'icon'  => 'el-icon-facebook'
            );
            $this->args['share_icons'][] = array(
                'url'   => 'http://twitter.com/reduxframework',
                'title' => 'Follow us on Twitter',
                'icon'  => 'el-icon-twitter'
            );
            $this->args['share_icons'][] = array(
                'url'   => 'http://www.linkedin.com/company/redux-framework',
                'title' => 'Find us on LinkedIn',
                'icon'  => 'el-icon-linkedin'
            );

            // Panel Intro text -> before the form
            if (!isset($this->args['global_variable']) || $this->args['global_variable'] !== false) {
                if (!empty($this->args['global_variable'])) {
                    $v = $this->args['global_variable'];
                } else {
                    $v = str_replace('-', '_', $this->args['opt_name']);
                }
                //$this->args['intro_text'] = sprintf(esc_html__('<p>Did you know that Redux sets a global variable for you? To access any of your saved options from within your code you can use your global variable: <strong>$%1$s</strong></p>', 'crown'), $v);
            } else {
                //$this->args['intro_text'] = esc_html__('<p>This text is displayed above the options panel. It isn\'t required, but more info is always better! The intro_text field accepts all HTML.</p>', 'crown');
            }

            // Add content after the form.
            //$this->args['footer_text'] = esc_html__('<p>This text is displayed below the options panel. It isn\'t required, but more info is always better! The footer_text field accepts all HTML.</p>', 'crown');
        }

    }   
    global $reduxConfig;
    $reduxConfig = new Crown_Theme_Config();
}

/**
  Custom function for the callback referenced above
 */
if (!function_exists('redux_my_custom_field')):
    function redux_my_custom_field($field, $value) {
        print_r($field);
        echo '<br/>';
        print_r($value);
    }
endif;

/**
  Custom function for the callback validation referenced above
 * */
if (!function_exists('redux_validate_callback_function')):
    function redux_validate_callback_function($field, $value, $existing_value) {
        $error = false;
        $value = 'just testing';

        /*
          do your validation

          if(something) {
            $value = $value;
          } elseif(something else) {
            $error = true;
            $value = $existing_value;
            $field['msg'] = 'your custom error message';
          }
         */

        $return['value'] = $value;
        if ($error == true) {
            $return['error'] = $field;
        }
        return $return;
    }
endif;
